
/* Copyright 1989 UserLand Software, Inc.  All Rights Reserved.*/

/* file:	IPCDriver.h
-- desc:	Public header file for IPCDriver
-- version:	V1.0
-- by:		Don Park
-- when:	November 1988
-- hist:	30Nov88 V1.0 DDP	New.
*/

#ifdef GLOBALSOK
#define	_IPCDrvrName		"\p.IPC Manager  1988 UserLand"
#define	_IPCFileName		"\pIPC Manager"
#endif

/* Control selector codes understood by IPC driver */
enum {
	csOpnIPCPrc = 256,	/* register a named Process */
	csClsIPCPrc,		/* unregister a Process */
	csFndIPCPrc,		/* find a named Process */
	csWhoIPCPrc,		/* return name of a Process */
	csSndIPCMsg,		/* send a Message from a Process to another Process */
	csRcvIPCMsg,		/* receive a Message from any Process to a Process */
	csClrIPCMsg			/* flush all Messages sent to a Process */
};

/* Structure passed through csParam field of CntrlParam block when
-- a Control code is sent.
*/
typedef struct	{		/* Process Parameter Block */
	PIN*	pin;		/* Process Name */
	PID		pid;		/* Process ID */
	PID		sender;		/* Sender Process ID */
	PID		receiver;	/* Receiver Process ID */
	Handle	message;	/* Message handle */
} _IPCParam;

